using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace TersPerspektif
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        double[,] Rt = new double[3, 3];  //ters transformasyon matrisi
        const double PI = 3.1415;
        int xa, ya, za;
        double alfa, beta, teta, xs, zs, D;

        private OpenFileDialog DosyaAcDiyalogu = new OpenFileDialog();
        Bitmap geciciBitmap = null; // Bitmap nesnesi tanmlanr
        Bitmap bitmap1=new Bitmap(400,400); // Bitmap nesnesi tanmlanr
        Image res1;


        //---------------------------------------------------------------------------
        // Bu fonksiyon ters transformasyon matrisinin deerlerini setler.
        private void ttransformasyon(double alfa, double beta, double teta)
        {
            

            Rt[0,0] = Math.Cos(beta * PI / 180) * Math.Cos(teta * PI / 180) + Math.Sin(beta * PI / 180) * Math.Sin(alfa * PI / 180) * Math.Sin(teta * PI / 180);
            Rt[0,1] = -(Math.Cos(beta * PI / 180) * Math.Sin(teta * PI / 180) + Math.Sin(beta * PI / 180) * Math.Sin(alfa * PI / 180) * Math.Cos(teta * PI / 180));
            Rt[0,2] = Math.Sin(beta * PI / 180) * Math.Cos(alfa * PI / 180);

            Rt[1,0] = Math.Cos(alfa * PI / 180) * Math.Sin(teta * PI / 180);
            Rt[1,1] = Math.Cos(alfa * PI / 180) * Math.Cos(teta * PI / 180);
            Rt[1,2] = Math.Sin(alfa * PI / 180) * (-1);

            Rt[2,0] = -(Math.Sin(beta * PI / 180) * Math.Cos(teta * PI / 180) + Math.Cos(beta * PI / 180) * Math.Sin(alfa * PI / 180) * Math.Sin(teta * PI / 180));
            Rt[2,1] = Math.Sin(beta * PI / 180) * Math.Sin(teta * PI / 180) + Math.Cos(beta * PI / 180) * Math.Sin(alfa * PI / 180) * Math.Cos(teta * PI / 180);
            Rt[2,2] = Math.Cos(beta * PI / 180) * Math.Cos(alfa * PI / 180);

          
        }


        //---------------------------------------------------------------------------
        //Bu fonksiyon kullancdan resim semesini ister ve bellee ykler.
        private void button1_Click(object sender, EventArgs e)
        {
                        // Save file dialog

                        
            DosyaAcDiyalogu.Filter = "Image files (*.bmp)|*.bmp|All files (*.*)|*.*";
            if (DosyaAcDiyalogu.ShowDialog() == DialogResult.OK)
            {
                Image Resim1 = Image.FromFile(DosyaAcDiyalogu.FileName);
 

                geciciBitmap = (Bitmap)Resim1.Clone();  //dosyadan okunan image nesnesi bitmap nesnesine dntrlr
                
                pictureBox2.Image = Resim1;

            }
        }


        //---------------------------------------------------------------------------
        //Bu fonksiyon girilen parametrelere gre 400x400'lk bir alana ters perspektif dnm ile doku kaplar.
        private void button2_Click(object sender, EventArgs e)
        {
            int i, j, f1, f2, f3, f4;
            double X, Y, Z, K, payda, den1, den2;

            //Eer resim henz seilmediyse kullancy uyar.
            if (String.IsNullOrEmpty(DosyaAcDiyalogu.FileName))
            {
                MessageBox.Show("Resim Seilmedi.");
                
                return;
            }


            //Kullancdan gzlemci koordinat sisteminin merkezini alr.
            xa = int.Parse(textBox1.Text);
            ya = int.Parse(textBox2.Text);
            za = int.Parse(textBox3.Text);
            //Kullancdan rotasyonlar alr.
            alfa = int.Parse(textBox4.Text);
            beta = int.Parse(textBox5.Text);
            teta = int.Parse(textBox6.Text);


            D = ya; // projeksiyon dzleminin merkezden uzakligi
            

            //ters transformasyon matrisini olutur.
            ttransformasyon(alfa, beta, teta);

            bitmap1 = new Bitmap(400,400); ;
            //ekran zerinde 400x400'lk bir alan tara (xs-zs koordinatlar).
            for (j = 0; j < 400; j++)
            {
                for (i = 0; i < 400; i++)
                {
                    //koordinatlar merkeze ta.
                    xs = i - 200;
                    zs = j - 200;
                    payda = Rt[2,0] * xs + D * Rt[2,1] + Rt[2,2] * zs;
                    if (payda == 0) //eer ufuk izgisinde isek K sonsuz kar. Bu noktay atlamalyz.
                        continue;
                    K = (-za / payda); //Z=0 yzeyi ele alnm.
                    //Bulunan K deerine gre X ve Y koordinatlar hesaplanyor.
                    X = xa + K * (Rt[0,0] * xs + D * Rt[0,1] + zs * Rt[0,2]);
                    Y = ya + K * (Rt[1,0] * xs + D * Rt[1,1] + zs * Rt[1,2]);

                    //Zemin olduunu belirtmek iin...
                    if (payda > 0)
                    { 
                        // X ve Y yi en yakn deere yuvarla.
                        f1 = (int)Math.Floor(X + 0.5);
                        f3 = (int)Math.Floor(Y + 0.5);
                        // mod ilemi yardmyla dokuyu kapla.
                        f2 = geciciBitmap.Width;
                        f4 = geciciBitmap.Height;
                        den1 =Math.Abs(f1 % f2);
                        den2 =Math.Abs(f3 % f4);
                        //Eer 0 noktasndan gerisini gryorsak grntnn btnl asndan ters alma yapmalyz.
                        if (X < 0)
                            den1 = geciciBitmap.Width - den1 - 1;
                        if (Y < 0)
                            den2 = (int)(geciciBitmap.Height - den2) % geciciBitmap.Height;
                        //lgili doku deerini ekrana bas.
                        //Form1->Canvas->Pixels[i][j] = Bitmap1->Canvas->Pixels[den1][den2];
                           //bitmap1 = (Bitmap)pictureBox1.Image;

                                      
                        bitmap1.SetPixel(i, j, geciciBitmap.GetPixel((int)den1,(int)den2));
                                                                  
                                           
                        
                    }
                }
            }
            pictureBox1.Image = bitmap1;
            

        }

        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
            textBox1.Text = numericUpDown1.Value.ToString();
        }

        private void numericUpDown2_ValueChanged(object sender, EventArgs e)
        {
            textBox2.Text = numericUpDown2.Value.ToString();
        }

 

        private void numericUpDown4_ValueChanged(object sender, EventArgs e)
        {
            textBox4.Text = numericUpDown4.Value.ToString();
        }

        private void numericUpDown5_ValueChanged(object sender, EventArgs e)
        {
            textBox5.Text = numericUpDown5.Value.ToString();
        }

        private void numericUpDown6_ValueChanged(object sender, EventArgs e)
        {
            textBox6.Text = numericUpDown6.Value.ToString();
        }

        private void numericUpDown3_ValueChanged(object sender, EventArgs e)
        {
            textBox3.Text = numericUpDown3.Value.ToString();
        }



  
    }
}